import { defineStore } from 'pinia';
import { ref } from 'vue';
import { useAuthStore } from './Auth.js';

export const useSuspiciousLoginStore = defineStore('suspiciousLogin', () => {
    const show = ref(false);
    const sessionId = ref(null);

    function trigger(session) {
        console.log('SuspiciousLoginStore: Trigger called with session:', session);
        show.value = true;
        sessionId.value = session;
        console.log('SuspiciousLoginStore: Modal should now be visible. show =', show.value, 'sessionId =', sessionId.value);
    }
    function close() {
        console.log('SuspiciousLoginStore: Close called');
        show.value = false;
        sessionId.value = null;
    }
    function dismiss() {
        console.log('SuspiciousLoginStore: Dismiss called');
        show.value = false;
        sessionId.value = null;
        // Reset the suspicious login flag in Auth store
        const authStore = useAuthStore();
        if (authStore.suspiciousLoginShown !== undefined) {
            authStore.suspiciousLoginShown = false;
        }
    }

    return { show, sessionId, trigger, close, dismiss };
}); 